#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z (1.f)
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0.f,0.f, 1.f/FOND_Z}};
static GrVertex Fond2 = {0.f,0.f,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f,0.f,1.f/300.f}};
static GrVertex Fond3 = {0.f,0.f,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f,0.f,1.f/FOND_Z}};
// we have to modify the "tow" coord of Fond3

// transparent backBigrid
static GrVertex FondA = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex FondB = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{128.f/FOND_Z,0,1.f/300.f}};
static GrVertex FondC = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{128.f/FOND_Z,128.f/FOND_Z,1.f/FOND_Z}};
static GrVertex FondD = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,128.f/FOND_Z,1.f/FOND_Z}};

// rotating square
static GrVertex Fond4 = {0.f,0.f,FOND_Z,  0,0,0,   0,32.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond5 = {640.f,0,FOND_Z,   0,0,0,   0,32.f,1.f/FOND_Z,{32.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond6 = {640.,480.,FOND_Z,   0,0,0,   0,32.f,1.f/FOND_Z,{32.f/FOND_Z,32.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond7 = {0,480.,FOND_Z,   0,0,0,   0,32.f,1.f/FOND_Z,{0,32.f/FOND_Z,1.f/FOND_Z}};

// rotating croix
static GrVertex Fond8 = {0.f,0.f,FOND_Z,  0,0,0,   0,32.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond9 = {640.f,0,FOND_Z,   0,0,0,   0,32.f,1.f/FOND_Z,{256,0,1.f/300.f}};
static GrVertex Fond10 = {640.,480.,FOND_Z,   0,0,0,   0,32.f,1.f/FOND_Z,{256,256,1.f/FOND_Z}};
static GrVertex Fond11 = {0,480.,FOND_Z,   0,0,0,   0,32.f,1.f/FOND_Z,{0,256,1.f/FOND_Z}};

typedef struct{
	float x,y;
}TourPoint;

void LInit_Tour()
{
	PrepareTextureFromArray(g_PicTour, 256, 256, &g_TextureTour);
}

void QInit_Tour()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grChromakeyValue(0);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);
	grCullMode(GR_CULL_DISABLE);

	DownloadTexture(&g_TextureTour);
	SelectTexture(g_TextureTour);
}

void Effect_Tour()
{
	float fPercent;
	int Cpt1;
	int E,F,G; // 3 vertices
	float fTmpX, fTmpY;
	static DWORD nAlpha = 0;
	DWORD dwTmp;

	// coord of points in screen
	TourPoint Points[4] =
	{
		{0,0},
		{640,0},
		{640,480},
		{0,480}
	};

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	if (g_demostate.TickInEffect<1024)
		nAlpha = g_demostate.TickInEffect/4;
	else
		nAlpha = 255;

	grConstantColorValue(0x50000000|nAlpha|(nAlpha<<8)|(nAlpha<<16));

	//fPercent = (float)CosTable[(g_demostate.TickInEffect * 6)&8191] /16.f + 0.0650f;
	fPercent = (float)CosTable[(g_demostate.TickInEffect * 6)&8191] /12.f + 0.0858f;

	Fond1.tmuvtx[0].tow = Fond1.tmuvtx[0].sow = g_demostate.TickInEffect / 10;
	Fond2.tmuvtx[0].sow = 256.f + (Fond2.tmuvtx[0].tow = g_demostate.TickInEffect / 10);
	Fond3.tmuvtx[0].sow = g_demostate.TickInEffect / 10 + 256.f;
	Fond3.tmuvtx[0].tow = 256.f * fPercent + g_demostate.TickInEffect / 10;

	/*Fond2.tmuvtx[0].tow = Fond1.tmuvtx[0].tow = Fond1.tmuvtx[0].sow = 0;
	Fond3.tmuvtx[0].sow = Fond2.tmuvtx[0].sow = 256.f;
	Fond3.tmuvtx[0].tow = 256.f * fPercent;*/
	//Fond3.tmuvtx[0].tow = 32.f;

	//Points[0].x = 640.f * fPercent;

	for(Cpt1=1;Cpt1<100;Cpt1++)
	{
		// which vertices
		E = Cpt1&3;
		F = (Cpt1+1)&3;
		G = (Cpt1+2)&3;

		Fond1.tmuvtx[0].sow+= 1.f;
		Fond1.tmuvtx[0].tow+= 1.f;
		Fond2.tmuvtx[0].sow+= 1.f;
		Fond2.tmuvtx[0].tow+= 1.f;
		Fond3.tmuvtx[0].sow+= 1.f;
		Fond3.tmuvtx[0].tow+= 1.f;

		// compute the new vertex
		fTmpX = Points[F].x * ( 1.f - fPercent ) + Points[G].x * fPercent;
		fTmpY = Points[F].y * ( 1.f - fPercent ) + Points[G].y * fPercent;

		// define the triangle
		Fond1.x = Points[E].x;	Fond1.y = Points[E].y;
		Fond2.x = Points[F].x;	Fond2.y = Points[F].y;
		Fond3.x = fTmpX;		Fond3.y = fTmpY;

		// update the modified vertex
		Points[F].x = fTmpX;
		Points[F].y = fTmpY;

		grDrawTriangle(&Fond1, &Fond2, &Fond3);
	}

	Fond4.x = Points[0].x;	Fond4.y = Points[0].y;
	Fond5.x = Points[1].x;	Fond5.y = Points[1].y;
	Fond6.x = Points[2].x;	Fond6.y = Points[2].y;
	Fond7.x = Points[3].x;	Fond7.y = Points[3].y;
	Fond4.tmuvtx[0].sow+= 1.f;	Fond4.tmuvtx[0].tow+= 1.f;
	Fond5.tmuvtx[0].sow+= 1.f;	Fond5.tmuvtx[0].tow+= 1.f;
	Fond6.tmuvtx[0].sow+= 1.f;	Fond6.tmuvtx[0].tow+= 1.f;
	Fond7.tmuvtx[0].sow+= 1.f;	Fond7.tmuvtx[0].tow+= 1.f;

	grDrawTriangle(&Fond4, &Fond5, &Fond6);
	grDrawTriangle(&Fond6, &Fond7, &Fond4);

	//grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);

	FondA.tmuvtx[0].sow ++; 
	FondA.tmuvtx[0].tow ++; 
	FondB.tmuvtx[0].sow ++; 
	FondB.tmuvtx[0].tow ++; 
	FondC.tmuvtx[0].sow ++; 
	FondC.tmuvtx[0].tow ++; 
	FondD.tmuvtx[0].sow ++; 
	FondD.tmuvtx[0].tow ++; 

	dwTmp = 192+63*CosTable[(g_demostate.TickInEffect*6+4096)&8191];
	if (dwTmp<nAlpha)
		grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
	grDrawTriangle(&FondA, &FondB, &FondC);
	grDrawTriangle(&FondC, &FondD, &FondA);
}

void ByeBye_Tour()
{
	FreeTexture(&g_TextureTour);
}
